/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.look;

import com.alibaba.bytekit.utils.MatchUtils;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.LineNumberNode;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import com.alibaba.deps.org.objectweb.asm.tree.VarInsnNode;
import com.taobao.arthas.common.Pair;
import com.taobao.arthas.core.util.EncryptUtils;
import com.taobao.arthas.core.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LookUtils {
    private static final String LOCATION_CODE_SPLITTER = "-";
    public static final String LOCAL_VARIABLES_NAME_EXCLUDE_MATCHER = "*$*";
    private static final String LOCATION_CONTENT_VARIABLE_FORMATTER = "assign-variable: %s";
    private static final String LOCATION_CONTENT_METHOD_FORMATTER = "invoke-method: %s#%s:%s";
    private static final String LOCATION_VIEW_LINE_FORMATTER = "/*%s*/   %s   %s";

    public static AbstractInsnNode findInsnNodeByLocationCode(MethodNode methodNode, String locationCode) {
        Pair<String, Integer> locationCodePair = LookUtils.convertToLocationCode(locationCode);
        Map<String, AbstractInsnNode> uniqMap = LookUtils.genLocationCodeMapNode(methodNode, locationCodePair.getFirst().length());
        return uniqMap.get(locationCode);
    }

    public static String renderMethodLocation(MethodNode methodNode) {
        Object[] lineArray = LookUtils.renderMethodView(methodNode).toArray();
        return StringUtils.join(lineArray, "\n");
    }

    public static Pair<String, Integer> convertToLocationCode(String location) {
        String[] arr = location.split(LOCATION_CODE_SPLITTER);
        return new Pair<String, Integer>(arr[0], Integer.valueOf(arr[1]));
    }

    public static boolean validLocation(String locationCode) {
        if (locationCode == null || locationCode.isEmpty()) {
            return false;
        }
        if (locationCode.contains(LOCATION_CODE_SPLITTER)) {
            String[] arr = locationCode.split(LOCATION_CODE_SPLITTER);
            if (arr.length != 2) {
                return false;
            }
            return StringUtils.isNumeric(arr[1]) && arr[1].length() < 8;
        }
        return StringUtils.isNumeric(locationCode) && locationCode.length() < 8;
    }

    public static boolean isLocationCode(String location) {
        return location.contains(LOCATION_CODE_SPLITTER);
    }

    private static boolean matchInsnNode(AbstractInsnNode abstractInsnNode, Set<Integer> allowVariableSet) {
        if (abstractInsnNode instanceof VarInsnNode) {
            switch (abstractInsnNode.getOpcode()) {
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    return allowVariableSet.contains(((VarInsnNode)abstractInsnNode).var);
                }
            }
            return false;
        }
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (methodInsnNode.owner.equals("java/arthas/SpyAPI")) {
                return false;
            }
            if (methodInsnNode.owner.equals("java/lang/Byte") || methodInsnNode.owner.equals("java/lang/Short") || methodInsnNode.owner.equals("java/lang/Integer") || methodInsnNode.owner.equals("java/lang/Long") || methodInsnNode.owner.equals("java/lang/Boolean") || methodInsnNode.owner.equals("java/lang/Float")) {
                return !methodInsnNode.name.equals("<init>");
            }
            return true;
        }
        return false;
    }

    private static int findPreLineNumber(AbstractInsnNode insnNode) {
        while (insnNode != null) {
            if (insnNode instanceof LineNumberNode) {
                return ((LineNumberNode)insnNode).line;
            }
            insnNode = insnNode.getPrevious();
        }
        return 0;
    }

    private static List<String> genLocationContentList(List<AbstractInsnNode> nodeList, Map<Integer, String> varIdxMap) {
        LinkedList<String> contentList = new LinkedList<String>();
        for (AbstractInsnNode abstractInsnNode : nodeList) {
            String content = "";
            if (abstractInsnNode instanceof VarInsnNode) {
                VarInsnNode varInsnNode = (VarInsnNode)abstractInsnNode;
                content = String.format(LOCATION_CONTENT_VARIABLE_FORMATTER, varIdxMap.get(varInsnNode.var));
            } else if (abstractInsnNode instanceof MethodInsnNode) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                content = String.format(LOCATION_CONTENT_METHOD_FORMATTER, methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
            }
            contentList.add(content);
        }
        return contentList;
    }

    private static List<Integer> genLineNumberList(List<AbstractInsnNode> nodeList) {
        LinkedList<Integer> preLineNumberList = new LinkedList<Integer>();
        for (AbstractInsnNode abstractInsnNode : nodeList) {
            int preLineNumber = LookUtils.findPreLineNumber(abstractInsnNode);
            preLineNumberList.add(preLineNumber);
        }
        return preLineNumberList;
    }

    private static List<AbstractInsnNode> filterNodeList(InsnList insnList, Map<Integer, String> varIdxMap) {
        LinkedList<AbstractInsnNode> noteList = new LinkedList<AbstractInsnNode>();
        for (AbstractInsnNode abstractInsnNode : insnList) {
            if (!LookUtils.matchInsnNode(abstractInsnNode, varIdxMap.keySet())) continue;
            noteList.add(abstractInsnNode);
        }
        return noteList;
    }

    private static List<String> renderMethodView(MethodNode methodNode) {
        LinkedList<String> printLines = new LinkedList<String>();
        HashMap<Integer, String> varIdxMap = new HashMap<Integer, String>();
        for (LocalVariableNode localVariable : methodNode.localVariables) {
            if (MatchUtils.wildcardMatch(localVariable.name, LOCAL_VARIABLES_NAME_EXCLUDE_MATCHER)) continue;
            varIdxMap.put(localVariable.index, localVariable.name);
        }
        List<AbstractInsnNode> noteList = LookUtils.filterNodeList(methodNode.instructions, varIdxMap);
        List<String> contentList = LookUtils.genLocationContentList(noteList, varIdxMap);
        List<Integer> preLineNumberList = LookUtils.genLineNumberList(noteList);
        List<Pair<String, String>> contentAndCode = LookUtils.genLocationCode(contentList);
        for (int i = 0; i < contentAndCode.size(); ++i) {
            Pair<String, String> contentCodePair = contentAndCode.get(i);
            Integer preLineNumber = preLineNumberList.get(i);
            String printLine = String.format(LOCATION_VIEW_LINE_FORMATTER, preLineNumber, contentCodePair.getSecond(), contentCodePair.getFirst());
            printLines.add(printLine);
        }
        return printLines;
    }

    private static Map<String, AbstractInsnNode> genLocationCodeMapNode(MethodNode methodNode, int uniqLength) {
        HashMap<Integer, String> varIdxMap = new HashMap<Integer, String>();
        for (LocalVariableNode localVariableNode : methodNode.localVariables) {
            if (MatchUtils.wildcardMatch(localVariableNode.name, LOCAL_VARIABLES_NAME_EXCLUDE_MATCHER)) continue;
            varIdxMap.put(localVariableNode.index, localVariableNode.name);
        }
        LinkedList<AbstractInsnNode> nodeList = new LinkedList<AbstractInsnNode>();
        for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
            if (!LookUtils.matchInsnNode(abstractInsnNode, varIdxMap.keySet())) continue;
            nodeList.add(abstractInsnNode);
        }
        List<String> list = LookUtils.genLocationContentList(nodeList, varIdxMap);
        HashMap<String, AbstractInsnNode> uniqMapNode = new HashMap<String, AbstractInsnNode>();
        HashMap<String, Integer> contentMapIdx = new HashMap<String, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            int n;
            String c = list.get(i);
            Integer lastIdx = (Integer)contentMapIdx.get(c);
            if (lastIdx == null) {
                n = 1;
            } else {
                lastIdx = lastIdx + 1;
                n = lastIdx;
            }
            int curIdx = n;
            contentMapIdx.put(c, curIdx);
            String md5 = EncryptUtils.md5DigestAsHex(c.getBytes()).substring(0, uniqLength);
            String locationCode = md5 + LOCATION_CODE_SPLITTER + curIdx;
            uniqMapNode.put(locationCode, (AbstractInsnNode)nodeList.get(i));
        }
        return uniqMapNode;
    }

    private static List<Pair<String, String>> genLocationCode(List<String> locationContentList) {
        int preSize = locationContentList.size();
        LinkedList<Pair<String, String>> locationContentAndCodeList = new LinkedList<Pair<String, String>>();
        HashSet<String> contentSet = new HashSet<String>(locationContentList);
        HashMap<String, String> contentMapMd5 = new HashMap<String, String>(preSize);
        for (String content : contentSet) {
            String project = EncryptUtils.md5DigestAsHex(content.getBytes());
            contentMapMd5.put(content, project);
        }
        int length = LookUtils.determineLocationCodeLength(contentMapMd5.values());
        HashMap<String, Integer> contentMapIdx = new HashMap<String, Integer>();
        for (String locationContent : locationContentList) {
            int n;
            Integer lastIdx = (Integer)contentMapIdx.get(locationContent);
            if (lastIdx == null) {
                n = 1;
            } else {
                lastIdx = lastIdx + 1;
                n = lastIdx;
            }
            int curIdx = n;
            contentMapIdx.put(locationContent, curIdx);
            String locationCode = locationContent + LOCATION_CODE_SPLITTER + curIdx;
            if (length != -1) {
                String md5 = (String)contentMapMd5.get(locationContent);
                locationCode = md5.substring(0, length) + LOCATION_CODE_SPLITTER + curIdx;
            }
            locationContentAndCodeList.add(new Pair<String, String>(locationContent, locationCode));
        }
        return locationContentAndCodeList;
    }

    private static int determineLocationCodeLength(Collection<String> md5List) {
        HashSet<String> md5Set = new HashSet<String>(md5List);
        if (md5Set.size() != md5List.size()) {
            return -1;
        }
        for (int i = 4; i < 32; ++i) {
            String md5;
            String uniq;
            HashSet<String> uniqSet = new HashSet<String>(md5Set.size());
            Iterator iterator = md5Set.iterator();
            while (iterator.hasNext() && uniqSet.add(uniq = (md5 = (String)iterator.next()).substring(0, i))) {
            }
            if (uniqSet.size() != md5Set.size()) continue;
            return i;
        }
        return -1;
    }
}

