/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util.look;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.StringBinding;
import com.alibaba.bytekit.asm.interceptor.InterceptorMethodConfig;
import com.alibaba.bytekit.asm.interceptor.InterceptorProcessor;
import com.alibaba.bytekit.asm.interceptor.annotation.BindingParserUtils;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.bytekit.asm.location.LocationType;
import com.alibaba.bytekit.asm.location.filter.LocationFilter;
import com.alibaba.bytekit.utils.ReflectionUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LineNumberNode;
import com.taobao.arthas.core.advisor.SpyInterceptors;
import com.taobao.arthas.core.util.look.LookUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class LookInterceptorParserUtils {
    public static InterceptorProcessor createLookInterceptorProcessor(String lookLocation) {
        Method method = ReflectionUtils.findMethod(SpyInterceptors.SpyLookInterceptor.class, "atLookLocationLine", null);
        if (LookUtils.isLocationCode(lookLocation)) {
            method = ReflectionUtils.findMethod(SpyInterceptors.SpyLookInterceptor.class, "atLookLocationCode", null);
        }
        InterceptorProcessor interceptorProcessor = new InterceptorProcessor(method.getDeclaringClass().getClassLoader());
        if (LookUtils.isLocationCode(lookLocation)) {
            interceptorProcessor.setLocationMatcher(new LookLocationCodeMatcher(lookLocation));
        } else {
            interceptorProcessor.setLocationMatcher(new LookLineNumberMatcher(lookLocation));
        }
        InterceptorMethodConfig interceptorMethodConfig = new InterceptorMethodConfig();
        interceptorProcessor.setInterceptorMethodConfig(interceptorMethodConfig);
        interceptorMethodConfig.setOwner(Type.getInternalName(method.getDeclaringClass()));
        interceptorMethodConfig.setMethodName(method.getName());
        interceptorMethodConfig.setMethodDesc(Type.getMethodDescriptor(method));
        interceptorMethodConfig.setInline(true);
        List<Binding> bindings = BindingParserUtils.parseBindings(method);
        for (Binding binding : bindings) {
            StringBinding stringBinding;
            if (!(binding instanceof StringBinding) || !(stringBinding = (StringBinding)binding).getValue().equals("LocationPlaceholder")) continue;
            stringBinding.setValue(lookLocation);
        }
        interceptorMethodConfig.setBindings(bindings);
        return interceptorProcessor;
    }

    public static class LookLocationCodeMatcher
    implements LocationMatcher {
        private String locationCode = "";

        public LookLocationCodeMatcher(String locationCode) {
            this.locationCode = locationCode;
        }

        @Override
        public List<Location> match(MethodProcessor methodProcessor) {
            ArrayList<Location> locations = new ArrayList<Location>();
            LocationFilter locationFilter = methodProcessor.getLocationFilter();
            AbstractInsnNode insnNode = LookUtils.findInsnNodeByLocationCode(methodProcessor.getMethodNode(), this.locationCode);
            if (insnNode == null) {
                throw new IllegalStateException("invalid locationCode:" + this.locationCode);
            }
            boolean filtered = !locationFilter.allow(insnNode, LocationType.USER_DEFINE, false);
            LookLocation location = new LookLocation(insnNode, this.locationCode, false, filtered);
            locations.add(location);
            return locations;
        }
    }

    public static class LookLineNumberMatcher
    implements LocationMatcher {
        private Integer targetLine;

        public LookLineNumberMatcher(String locationCode) {
            this.targetLine = Integer.valueOf(locationCode);
        }

        @Override
        public List<Location> match(MethodProcessor methodProcessor) {
            ArrayList<Location> locations = new ArrayList<Location>();
            LocationFilter locationFilter = methodProcessor.getLocationFilter();
            for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
                LookLocation location;
                boolean filtered;
                if (this.targetLine == -1) {
                    InsnNode node;
                    if (!(insnNode instanceof InsnNode) || !this.matchExit(node = (InsnNode)insnNode)) continue;
                    filtered = !locationFilter.allow(node, LocationType.LINE, false);
                    location = new LookLocation(node, this.targetLine.toString(), false, filtered);
                    locations.add(location);
                    continue;
                }
                if (!(insnNode instanceof LineNumberNode)) continue;
                LineNumberNode lineNumberNode = (LineNumberNode)insnNode;
                if (!this.matchLine(lineNumberNode.line)) continue;
                filtered = !locationFilter.allow(lineNumberNode, LocationType.LINE, false);
                location = new LookLocation(lineNumberNode.getPrevious(), this.targetLine.toString(), false, filtered);
                locations.add(location);
                break;
            }
            return locations;
        }

        private boolean matchLine(int line) {
            return line == this.targetLine;
        }

        public boolean matchExit(InsnNode node) {
            switch (node.getOpcode()) {
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class LookLocation
    extends Location {
        private String location;

        public LookLocation(AbstractInsnNode insnNode, String location, boolean whenComplete, boolean filtered) {
            super(insnNode, whenComplete, filtered);
            this.location = location;
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.USER_DEFINE;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }
    }
}

