/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env.convert;

import com.taobao.arthas.core.env.convert.ConfigurableConversionService;
import com.taobao.arthas.core.env.convert.Converter;
import com.taobao.arthas.core.env.convert.ConvertiblePair;
import com.taobao.arthas.core.env.convert.StringToArrayConverter;
import com.taobao.arthas.core.env.convert.StringToBooleanConverter;
import com.taobao.arthas.core.env.convert.StringToEnumConverter;
import com.taobao.arthas.core.env.convert.StringToInetAddressConverter;
import com.taobao.arthas.core.env.convert.StringToIntegerConverter;
import com.taobao.arthas.core.env.convert.StringToLongConverter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultConversionService
implements ConfigurableConversionService {
    private static ConcurrentHashMap<ConvertiblePair, Converter> converters = new ConcurrentHashMap();

    public DefaultConversionService() {
        this.addDefaultConverter();
    }

    private void addDefaultConverter() {
        converters.put(new ConvertiblePair(String.class, Integer.class), new StringToIntegerConverter());
        converters.put(new ConvertiblePair(String.class, Long.class), new StringToLongConverter());
        converters.put(new ConvertiblePair(String.class, Boolean.class), new StringToBooleanConverter());
        converters.put(new ConvertiblePair(String.class, InetAddress.class), new StringToInetAddressConverter());
        converters.put(new ConvertiblePair(String.class, Enum.class), new StringToEnumConverter());
        converters.put(new ConvertiblePair(String.class, Arrays.class), new StringToArrayConverter(this));
    }

    @Override
    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (sourceType == targetType) {
            return true;
        }
        if (targetType.isPrimitive()) {
            targetType = DefaultConversionService.objectiveClass(targetType);
        }
        if (converters.containsKey(new ConvertiblePair(sourceType, targetType))) {
            return true;
        }
        if (targetType.isEnum() && converters.containsKey(new ConvertiblePair(sourceType, Enum.class))) {
            return true;
        }
        return targetType.isArray();
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        Converter converter;
        if (targetType.isPrimitive()) {
            targetType = DefaultConversionService.objectiveClass(targetType);
        }
        if ((converter = converters.get(new ConvertiblePair(source.getClass(), targetType))) == null && targetType.isArray()) {
            converter = converters.get(new ConvertiblePair(source.getClass(), Arrays.class));
        }
        if (converter == null && targetType.isEnum()) {
            converter = converters.get(new ConvertiblePair(source.getClass(), Enum.class));
        }
        if (converter != null) {
            return (T)converter.convert(source, targetType);
        }
        return (T)source;
    }

    public static <C> Class<C[]> arrayClass(Class<C> klass) {
        return Array.newInstance(klass, 0).getClass();
    }

    public static Class<?> objectiveClass(Class<?> klass) {
        Class<?> component = klass.getComponentType();
        if (component != null) {
            if (component.isPrimitive() || component.isArray()) {
                return DefaultConversionService.arrayClass(DefaultConversionService.objectiveClass(component));
            }
        } else if (klass.isPrimitive()) {
            if (klass == Character.TYPE) {
                return Character.class;
            }
            if (klass == Integer.TYPE) {
                return Integer.class;
            }
            if (klass == Boolean.TYPE) {
                return Boolean.class;
            }
            if (klass == Byte.TYPE) {
                return Byte.class;
            }
            if (klass == Double.TYPE) {
                return Double.class;
            }
            if (klass == Float.TYPE) {
                return Float.class;
            }
            if (klass == Long.TYPE) {
                return Long.class;
            }
            if (klass == Short.TYPE) {
                return Short.class;
            }
        }
        return klass;
    }
}

