/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.model.MemoryEntryVO;
import com.taobao.arthas.core.command.model.MemoryModel;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.Style;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Map;

public class MemoryView
extends ResultView<MemoryModel> {
    @Override
    public void draw(CommandProcess process, MemoryModel result) {
        TableElement table = MemoryView.drawMemoryInfo(result.getMemoryInfo());
        process.write(RenderUtil.render(table, process.width()));
    }

    static TableElement drawMemoryInfo(Map<String, List<MemoryEntryVO>> memoryInfo) {
        TableElement table = new TableElement(3, 1, 1, 1, 1).rightCellPadding(1);
        table.add(new RowElement().style(Decoration.bold.fg(Color.black).bg(Color.white)).add("Memory", "used", "total", "max", "usage"));
        List<MemoryEntryVO> heapMemoryEntries = memoryInfo.get("heap");
        for (MemoryEntryVO memoryEntryVO : heapMemoryEntries) {
            if ("heap".equals(memoryEntryVO.getName())) {
                new MemoryEntry(memoryEntryVO).addTableRow(table, Decoration.bold.bold());
                continue;
            }
            new MemoryEntry(memoryEntryVO).addTableRow(table);
        }
        List<MemoryEntryVO> nonheapMemoryEntries = memoryInfo.get("nonheap");
        for (MemoryEntryVO memoryEntryVO : nonheapMemoryEntries) {
            if ("nonheap".equals(memoryEntryVO.getName())) {
                new MemoryEntry(memoryEntryVO).addTableRow(table, Decoration.bold.bold());
                continue;
            }
            new MemoryEntry(memoryEntryVO).addTableRow(table);
        }
        List<MemoryEntryVO> list = memoryInfo.get("buffer_pool");
        if (list != null) {
            for (MemoryEntryVO memoryEntryVO : list) {
                new MemoryEntry(memoryEntryVO).addTableRow(table);
            }
        }
        return table;
    }

    static class MemoryEntry {
        String name;
        long used;
        long total;
        long max;
        int unit;
        String unitStr;

        public MemoryEntry(String name, long used, long total, long max) {
            this.name = name;
            this.used = used;
            this.total = total;
            this.max = max;
            this.unitStr = "K";
            this.unit = 1024;
            if (used / 1024L / 1024L > 0L) {
                this.unitStr = "M";
                this.unit = 0x100000;
            }
        }

        public MemoryEntry(String name, MemoryUsage usage) {
            this(name, usage.getUsed(), usage.getCommitted(), usage.getMax());
        }

        public MemoryEntry(MemoryEntryVO memoryEntryVO) {
            this(memoryEntryVO.getName(), memoryEntryVO.getUsed(), memoryEntryVO.getTotal(), memoryEntryVO.getMax());
        }

        private String format(long value) {
            String valueStr = "-";
            if (value == -1L) {
                return "-1";
            }
            if (value != Long.MIN_VALUE) {
                valueStr = value / (long)this.unit + this.unitStr;
            }
            return valueStr;
        }

        public void addTableRow(TableElement table) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            if (Double.isNaN(usage) || Double.isInfinite(usage)) {
                usage = 0.0;
            }
            table.row(this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage));
        }

        public void addTableRow(TableElement table, Style.Composite style) {
            double usage = (double)this.used / (double)(this.max == -1L || this.max == Long.MIN_VALUE ? this.total : this.max) * 100.0;
            if (Double.isNaN(usage) || Double.isInfinite(usage)) {
                usage = 0.0;
            }
            table.add(new RowElement().style(style).add(this.name, this.format(this.used), this.format(this.total), this.format(this.max), String.format("%.2f%%", usage)));
        }
    }
}

