/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.LookAdviceListener;
import com.taobao.arthas.core.shell.cli.Completion;
import com.taobao.arthas.core.shell.cli.CompletionUtils;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.look.LookUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.DefaultValue;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;
import java.util.Arrays;

@Name(value="look")
@Summary(value="Display the local variables, input parameter of method specified with LineNumber or LocationCode(found in jad command)")
@Description(value="  The express may be one of the following expression:\n               target : the object\n                clazz : the object's class\n               method : the constructor or method\n               params : the parameters array of method\n         params[0..n] : the element of parameters array\n               varMap : the local variables map\n  varMap[\"varName\"] : the local variable value of varName\n\nExamples:\n  look com.arthas.controller.Controller doSomething -1 \n  look com.arthas.controller.Controller doSomething -1 'varMap'\n  look com.arthas.controller.Controller doSomething 35 'varMap'  'varMap[\"varName\"].equals(\"123\")'\n  look OuterClass$InnerClass doSomething 128 '{params,varMap}'  \n  look com.arthas.controller.Controller doSomething abcd-1 'varMap'\n\nWIKI:\n  https://arthas.aliyun.com/doc/look")
public class LookCommand
extends EnhancerCommand {
    private String classPattern;
    private String methodPattern;
    private String express;
    private String location;
    private String conditionExpress;
    private Integer expand = 1;
    private Integer sizeLimit = 0xA00000;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;

    @Argument(index=0, argName="class-pattern")
    @Description(value="The full qualified class name you want to look")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(index=1, argName="method-pattern")
    @Description(value="The method name you want to look in")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(index=2, argName="location")
    @Description(value="The location will be look before(LineNumber) or after(LocationCode).")
    public void setLocation(String location) {
        this.location = location;
    }

    @Argument(index=3, argName="express", required=false)
    @DefaultValue(value="varMap")
    @Description(value="The content you want to look, written by ognl. Default value is 'varMap'\n")
    public void setExpress(String express) {
        this.express = express;
    }

    @Argument(index=4, argName="condition-express", required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n  '#cost>100'\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="M", longName="sizeLimit")
    @Description(value="Upper size limit in bytes for the result (10 * 1024 * 1024 by default)")
    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    @Option(shortName="x", longName="expand")
    @Description(value="Expand level of object (1 by default), the max value is 4")
    public void setExpand(Integer expand) {
        this.expand = expand;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getExpress() {
        return this.express;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public Integer getExpand() {
        return this.expand;
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getClassNameExcludeMatcher() {
        if (this.classNameExcludeMatcher == null && this.getExcludeClassPattern() != null) {
            this.classNameExcludeMatcher = SearchUtils.classNameMatcher(this.getExcludeClassPattern(), this.isRegEx());
        }
        return this.classNameExcludeMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        return new LookAdviceListener(this, process, GlobalOptions.verbose || this.verbose);
    }

    @Override
    protected void completeArgument3(Completion completion) {
        CompletionUtils.complete(completion, Arrays.asList(EnhancerCommand.LOOK_EXPRESS_EXAMPLES));
    }

    @Override
    public void process(CommandProcess process) {
        if (!LookUtils.validLocation(this.location)) {
            throw new IllegalArgumentException("location is invalid! " + this.location);
        }
        super.process(process);
    }
}

