/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.meta;

import com.alibaba.bytekit.asm.meta.ClassMeta;
import com.alibaba.bytekit.asm.meta.ClassMetaCache;
import com.alibaba.bytekit.utils.ClassLoaderUtils;
import com.alibaba.bytekit.utils.concurrent.ConcurrentWeakKeyHashMap;
import java.util.List;
import java.util.Set;

public class ClassMetaService {
    private static final ConcurrentWeakKeyHashMap<ClassLoader, ClassMetaCache> cacheMap = new ConcurrentWeakKeyHashMap();

    public static ClassMetaCache findClassMetaCache(ClassLoader classLoader) {
        ClassMetaCache classMetaCache = cacheMap.get(classLoader = ClassLoaderUtils.wrap(classLoader));
        if (classMetaCache == null) {
            cacheMap.putIfAbsent(classLoader, new ClassMetaCache(classLoader));
            classMetaCache = cacheMap.get(classLoader);
        }
        return classMetaCache;
    }

    public static Set<String> allInterfaces(ClassLoader loader, String internalClassName, byte[] classfileBuffer) {
        ClassMetaCache classMetaCache = ClassMetaService.findClassMetaCache(loader);
        ClassMeta classMeta = classMetaCache.findAndTryLoadClassMeta(internalClassName, classfileBuffer);
        return classMeta.allInterfaces(classMetaCache);
    }

    public static List<String> allSuperNames(ClassLoader loader, String internalClassName, byte[] classfileBuffer) {
        ClassMetaCache classMetaCache = ClassMetaService.findClassMetaCache(loader);
        ClassMeta classMeta = classMetaCache.findAndTryLoadClassMeta(internalClassName, classfileBuffer);
        return classMeta.allSuperNames(classMetaCache);
    }
}

