/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.binding;

import com.alibaba.bytekit.asm.binding.ArgNamesBinding;
import com.alibaba.bytekit.asm.binding.ArgsBinding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.asm.binding.ClassBinding;
import com.alibaba.bytekit.asm.binding.FieldBinding;
import com.alibaba.bytekit.asm.binding.InvokeArgsBinding;
import com.alibaba.bytekit.asm.binding.InvokeInfoBinding;
import com.alibaba.bytekit.asm.binding.InvokeMethodDeclarationBinding;
import com.alibaba.bytekit.asm.binding.InvokeMethodNameBinding;
import com.alibaba.bytekit.asm.binding.InvokeMethodOwnerBinding;
import com.alibaba.bytekit.asm.binding.InvokeReturnBinding;
import com.alibaba.bytekit.asm.binding.LineBinding;
import com.alibaba.bytekit.asm.binding.LocalVarNamesBinding;
import com.alibaba.bytekit.asm.binding.LocalVarsBinding;
import com.alibaba.bytekit.asm.binding.MethodBinding;
import com.alibaba.bytekit.asm.binding.MethodDeclarationBinding;
import com.alibaba.bytekit.asm.binding.MethodInfoBinding;
import com.alibaba.bytekit.asm.binding.MethodNameBinding;
import com.alibaba.bytekit.asm.binding.MonitorBinding;
import com.alibaba.bytekit.asm.binding.ReturnBinding;
import com.alibaba.bytekit.asm.binding.StringBinding;
import com.alibaba.bytekit.asm.binding.ThisBinding;
import com.alibaba.bytekit.asm.binding.ThrowableBinding;
import com.alibaba.bytekit.asm.binding.annotation.BindingParser;
import com.alibaba.bytekit.asm.binding.annotation.BindingParserHandler;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public abstract class Binding {
    public boolean optional() {
        return false;
    }

    public boolean check(BindingContext bindingContext) {
        return true;
    }

    public abstract void pushOntoStack(InsnList var1, BindingContext var2);

    public abstract Type getType(BindingContext var1);

    public boolean fromStack() {
        return false;
    }

    public static class MonitorBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MonitorBinding();
        }
    }

    public static class StringBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            StringValue stringValue = (StringValue)annotation;
            return new StringBinding(stringValue.value());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=StringBindingParser.class)
    public static @interface StringValue {
        public String value() default "";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MonitorBindingParser.class)
    public static @interface Monitor {
        public boolean optional() default false;
    }

    public static class LineBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            Line line = (Line)annotation;
            return new LineBinding(line.exact());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LineBindingParser.class)
    public static @interface Line {
        public boolean optional() default false;

        public boolean exact() default false;
    }

    public static class ThrowableBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ThrowableBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ThrowableBindingParser.class)
    public static @interface Throwable {
        public boolean optional() default false;
    }

    public static class ThisBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ThisBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ThisBindingParser.class)
    public static @interface This {
    }

    public static class ReturnBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ReturnBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ReturnBindingParser.class)
    public static @interface Return {
        public boolean optional() default false;
    }

    public static class MethodInfoBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodInfoBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodInfoBindingParser.class)
    public static @interface MethodInfo {
        public boolean optional() default false;
    }

    public static class MethodDescBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodDeclarationBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodDescBindingParser.class)
    public static @interface MethodDesc {
        public boolean optional() default false;
    }

    public static class MethodNameBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodNameBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodNameBindingParser.class)
    public static @interface MethodName {
        public boolean optional() default false;
    }

    public static class MethodBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new MethodBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=MethodBindingParser.class)
    public static @interface Method {
        public boolean optional() default false;
    }

    public static class InvokeInfoBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeInfoBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeInfoBindingParser.class)
    public static @interface InvokeInfo {
        public boolean optional() default false;
    }

    public static class InvokeMethodDeclarationBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodDeclarationBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodDeclarationBindingParser.class)
    public static @interface InvokeMethodDeclaration {
        public boolean optional() default false;
    }

    public static class InvokeMethodOwnerBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodOwnerBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodOwnerBindingParser.class)
    public static @interface InvokeMethodOwner {
        public boolean optional() default false;
    }

    public static class InvokeMethodNameBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeMethodNameBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeMethodNameBindingParser.class)
    public static @interface InvokeMethodName {
        public boolean optional() default false;
    }

    public static class InvokeReturnBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeReturnBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeReturnBindingParser.class)
    public static @interface InvokeReturn {
        public boolean optional() default false;
    }

    public static class InvokeArgsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new InvokeArgsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=InvokeArgsBindingParser.class)
    public static @interface InvokeArgs {
        public boolean optional() default false;
    }

    public static class FieldBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            Field field = (Field)annotation;
            Type ownerType = Type.getType(field.owner());
            if (field.owner().equals(Void.class)) {
                ownerType = null;
            }
            Type fieldType = Type.getType(field.type());
            if (field.type().equals(Void.class)) {
                fieldType = null;
            }
            return new FieldBinding(ownerType, field.name(), fieldType, field.isStatic(), field.box());
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=FieldBindingParser.class)
    public static @interface Field {
        public boolean optional() default false;

        public java.lang.Class<?> owner() default Void.class;

        public java.lang.Class<?> type() default Void.class;

        public String name();

        public boolean isStatic() default false;

        public boolean box() default false;
    }

    public static class ClassBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ClassBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ClassBindingParser.class)
    public static @interface Class {
        public boolean optional() default false;
    }

    public static class LocalVarNamesBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            if (annotation instanceof LocalVarNames) {
                LocalVarNames localVarNames = (LocalVarNames)annotation;
                return new LocalVarNamesBinding(localVarNames.excludePattern());
            }
            return new LocalVarNamesBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LocalVarNamesBindingParser.class)
    public static @interface LocalVarNames {
        public String excludePattern() default "";

        public boolean optional() default false;
    }

    public static class LocalVarsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            if (annotation instanceof LocalVars) {
                LocalVars LocalVars2 = (LocalVars)annotation;
                return new LocalVarsBinding(LocalVars2.excludePattern());
            }
            return new LocalVarsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=LocalVarsBindingParser.class)
    public static @interface LocalVars {
        public String excludePattern() default "";

        public boolean optional() default false;
    }

    public static class ArgNamesBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ArgNamesBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ArgNamesBindingParser.class)
    public static @interface ArgNames {
        public boolean optional() default false;
    }

    public static class ArgsBindingParser
    implements BindingParser {
        @Override
        public Binding parse(Annotation annotation) {
            return new ArgsBinding();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingParserHandler(parser=ArgsBindingParser.class)
    public static @interface Args {
        public boolean optional() default false;
    }
}

