/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import com.alibaba.arthas.deps.io.netty.buffer.ByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.Unpooled;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.channel.group.ChannelGroup;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.termd.core.function.Consumer;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.tty.TtyConnection;
import java.util.concurrent.TimeUnit;

public class TtyWebSocketFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private ChannelHandlerContext context;
    private HttpTtyConnection conn;
    private Class removingHandlerClass;

    public TtyWebSocketFrameHandler(ChannelGroup group, Consumer<TtyConnection> handler, Class removingHandlerClass) {
        this.group = group;
        this.handler = handler;
        this.removingHandlerClass = removingHandlerClass;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.context = ctx;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            if (this.removingHandlerClass != null) {
                ctx.pipeline().remove(this.removingHandlerClass);
            }
            this.group.add(ctx.channel());
            this.conn = new HttpTtyConnection(){

                @Override
                protected void write(byte[] buffer) {
                    ByteBuf byteBuf = Unpooled.buffer();
                    byteBuf.writeBytes(buffer);
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.writeAndFlush(new TextWebSocketFrame(byteBuf));
                    }
                }

                @Override
                public void schedule(Runnable task, long delay, TimeUnit unit) {
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.executor().schedule(task, delay, unit);
                    }
                }

                @Override
                public void execute(Runnable task) {
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.executor().execute(task);
                    }
                }

                @Override
                public void close() {
                    if (TtyWebSocketFrameHandler.this.context != null) {
                        TtyWebSocketFrameHandler.this.context.close();
                    }
                }
            };
            this.handler.accept(this.conn);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Consumer<Void> closeHandler;
        HttpTtyConnection tmp = this.conn;
        this.context = null;
        this.conn = null;
        if (tmp != null && (closeHandler = tmp.getCloseHandler()) != null) {
            closeHandler.accept(null);
        }
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        this.conn.writeToDecoder(msg.text());
    }
}

