/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.io.netty.channel.ChannelHandler;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInitializer;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPipeline;
import com.alibaba.arthas.deps.io.netty.channel.group.ChannelGroup;
import com.alibaba.arthas.deps.io.netty.channel.socket.SocketChannel;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpServerCodec;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import com.alibaba.arthas.deps.io.netty.handler.stream.ChunkedWriteHandler;
import com.alibaba.arthas.deps.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.arthas.deps.io.netty.util.concurrent.EventExecutorGroup;
import com.taobao.arthas.core.shell.term.impl.http.BasicHttpAuthenticatorHandler;
import com.taobao.arthas.core.shell.term.impl.http.HttpRequestHandler;
import com.taobao.arthas.core.shell.term.impl.http.TtyWebSocketFrameHandler;
import com.taobao.arthas.core.shell.term.impl.http.session.HttpSessionManager;
import io.termd.core.function.Consumer;
import io.termd.core.tty.TtyConnection;

public class TtyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private EventExecutorGroup workerGroup;
    private HttpSessionManager httpSessionManager;

    public TtyServerInitializer(ChannelGroup group, Consumer<TtyConnection> handler, EventExecutorGroup workerGroup, HttpSessionManager httpSessionManager) {
        this.group = group;
        this.handler = handler;
        this.workerGroup = workerGroup;
        this.httpSessionManager = httpSessionManager;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(new HttpObjectAggregator(0xA00000));
        pipeline.addLast(new BasicHttpAuthenticatorHandler(this.httpSessionManager));
        pipeline.addLast(this.workerGroup, "HttpRequestHandler", (ChannelHandler)new HttpRequestHandler("/ws"));
        pipeline.addLast(new WebSocketServerProtocolHandler("/ws", null, false, 0xA00000, false, true));
        pipeline.addLast(new IdleStateHandler(0, 0, 60));
        pipeline.addLast(new TtyWebSocketFrameHandler(this.group, this.handler));
    }
}

