/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.distribution.impl;

import com.alibaba.arthas.deps.com.alibaba.fastjson.JSON;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.command.model.ResultModel;
import com.taobao.arthas.core.distribution.DistributorOptions;
import com.taobao.arthas.core.distribution.ResultConsumer;
import com.taobao.arthas.core.distribution.ResultConsumerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ResultConsumerImpl
implements ResultConsumer {
    private static final Logger logger = LoggerFactory.getLogger(ResultConsumerImpl.class);
    private BlockingQueue<ResultModel> resultQueue;
    private volatile long lastAccessTime;
    private volatile boolean polling;
    private ReentrantLock lock = new ReentrantLock();
    private int resultBatchSizeLimit = 20;
    private int resultQueueSize = DistributorOptions.resultQueueSize;
    private long pollTimeLimit = 2000L;
    private String consumerId;
    private boolean closed;
    private long sendingItemCount;

    public ResultConsumerImpl() {
        this.lastAccessTime = System.currentTimeMillis();
        this.resultQueue = new ArrayBlockingQueue<ResultModel>(this.resultQueueSize);
    }

    @Override
    public boolean appendResult(ResultModel result) {
        boolean discard = false;
        while (!this.resultQueue.offer(result)) {
            ResultModel discardResult = (ResultModel)this.resultQueue.poll();
            discard = true;
        }
        return !discard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResultModel> pollResults() {
        try {
            long accessTime = this.lastAccessTime = System.currentTimeMillis();
            if (this.lock.tryLock(500L, TimeUnit.MILLISECONDS)) {
                this.polling = true;
                this.sendingItemCount = 0L;
                long firstResultTime = 0L;
                long sendingDelay = 0L;
                long waitingTime = 0L;
                ArrayList<ResultModel> sendingResults = new ArrayList<ResultModel>(this.resultBatchSizeLimit);
                while (!this.closed && sendingResults.size() < this.resultBatchSizeLimit && sendingDelay < 100L && waitingTime < this.pollTimeLimit) {
                    ResultModel aResult = this.resultQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (aResult != null) {
                        sendingResults.add(aResult);
                        if (firstResultTime == 0L) {
                            firstResultTime = System.currentTimeMillis();
                        }
                        if (!this.shouldFlush(sendingResults, aResult)) continue;
                        break;
                    }
                    if (firstResultTime > 0L) {
                        sendingDelay = System.currentTimeMillis() - firstResultTime;
                    }
                    waitingTime = System.currentTimeMillis() - accessTime;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("pollResults: {}, results: {}", (Object)sendingResults.size(), (Object)JSON.toJSONString(sendingResults));
                }
                ArrayList<ResultModel> arrayList = sendingResults;
                return arrayList;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lastAccessTime = System.currentTimeMillis();
                this.polling = false;
                this.lock.unlock();
            }
        }
        return Collections.emptyList();
    }

    private boolean shouldFlush(List<ResultModel> sendingResults, ResultModel last) {
        this.sendingItemCount += (long)ResultConsumerHelper.getItemCount(last);
        return this.sendingItemCount >= 100L;
    }

    @Override
    public boolean isHealthy() {
        return this.isPolling() || this.resultQueue.size() < this.resultQueueSize || System.currentTimeMillis() - this.lastAccessTime < 1000L;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPolling() {
        return this.polling;
    }

    public int getResultBatchSizeLimit() {
        return this.resultBatchSizeLimit;
    }

    public void setResultBatchSizeLimit(int resultBatchSizeLimit) {
        this.resultBatchSizeLimit = resultBatchSizeLimit;
    }

    @Override
    public String getConsumerId() {
        return this.consumerId;
    }

    @Override
    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }
}

