/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.meta;

import com.alibaba.bytekit.asm.meta.ClassMetaCache;
import com.alibaba.deps.org.objectweb.asm.ClassReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassMeta {
    private String internalClassName;
    private String internalSuperName;
    private Set<String> interfaces = new HashSet<String>();

    public ClassMeta() {
    }

    public ClassMeta(String internalClassName, String internalSuperName, String[] interfaces) {
        this.internalClassName = internalClassName;
        this.internalSuperName = internalSuperName;
        if (interfaces != null) {
            for (String i : interfaces) {
                this.interfaces.add(i);
            }
        }
    }

    public ClassMeta(String internalClassName, String internalSuperName, Set<String> interfaces) {
        this.internalClassName = internalClassName;
        this.internalSuperName = internalSuperName;
        this.interfaces = interfaces;
    }

    public static ClassMeta fromByteCode(byte[] classfileBuffer) {
        if (classfileBuffer == null) {
            return null;
        }
        ClassReader reader = new ClassReader(classfileBuffer);
        String clazzName = reader.getClassName();
        String superName = reader.getSuperName();
        String[] interfacesArray = reader.getInterfaces();
        return new ClassMeta(clazzName, superName, interfacesArray);
    }

    public Set<String> allInterfaces(ClassMetaCache classMetaCache) {
        ClassMeta classMeta;
        HashSet<String> result = new HashSet<String>(this.interfaces);
        if (this.internalSuperName != null && (classMeta = classMetaCache.findClassMeta(this.internalSuperName)) != null) {
            result.addAll(classMeta.allInterfaces(classMetaCache));
        }
        for (String interfaceName : this.interfaces) {
            ClassMeta classMeta2 = classMetaCache.findClassMeta(interfaceName);
            if (classMeta2 == null) continue;
            result.addAll(classMeta2.allInterfaces(classMetaCache));
        }
        return result;
    }

    public List<String> allSuperNames(ClassMetaCache classMetaCache) {
        ArrayList<String> result = new ArrayList<String>();
        String superName = this.internalSuperName;
        while (superName != null) {
            result.add(superName);
            ClassMeta classMeta = classMetaCache.findClassMeta(superName);
            if (classMeta == null) break;
            superName = classMeta.getInternalSuperName();
        }
        return result;
    }

    public String getInternalClassName() {
        return this.internalClassName;
    }

    public void setInternalClassName(String internalClassName) {
        this.internalClassName = internalClassName;
    }

    public String getInternalSuperName() {
        return this.internalSuperName;
    }

    public void setInternalSuperName(String internalSuperName) {
        this.internalSuperName = internalSuperName;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }
}

