/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.deps.io.netty.bootstrap.Bootstrap;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInitializer;
import com.alibaba.arthas.deps.io.netty.channel.ChannelOption;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPipeline;
import com.alibaba.arthas.deps.io.netty.channel.EventLoopGroup;
import com.alibaba.arthas.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.arthas.deps.io.netty.channel.socket.SocketChannel;
import com.alibaba.arthas.deps.io.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import com.alibaba.arthas.deps.io.netty.handler.ssl.SslContext;
import com.alibaba.arthas.deps.io.netty.handler.ssl.SslContextBuilder;
import com.alibaba.arthas.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.alibaba.arthas.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.ForwardClientSocketClientHandler;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.SSLException;

public class ForwardClient {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClient.class);
    private URI tunnelServerURI;

    public ForwardClient(URI tunnelServerURI) {
        this.tunnelServerURI = tunnelServerURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws URISyntaxException, SSLException, InterruptedException {
        block6: {
            NioEventLoopGroup group;
            block5: {
                String host;
                String scheme = this.tunnelServerURI.getScheme() == null ? "ws" : this.tunnelServerURI.getScheme();
                String string = host = this.tunnelServerURI.getHost() == null ? "127.0.0.1" : this.tunnelServerURI.getHost();
                final int port = this.tunnelServerURI.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : this.tunnelServerURI.getPort();
                if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                    logger.error("Only WS(S) is supported, uri: {}", (Object)this.tunnelServerURI);
                    return;
                }
                boolean ssl = "wss".equalsIgnoreCase(scheme);
                final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
                WebSocketClientProtocolConfig clientProtocolConfig = WebSocketClientProtocolConfig.newBuilder().webSocketUri(this.tunnelServerURI).maxFramePayloadLength(0xA00000).build();
                final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(clientProtocolConfig);
                final ForwardClientSocketClientHandler forwardClientSocketClientHandler = new ForwardClientSocketClientHandler();
                group = new NioEventLoopGroup(1, new DefaultThreadFactory("arthas-ForwardClient", true));
                ChannelFuture closeFuture = null;
                try {
                    Bootstrap b = new Bootstrap();
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
                    ((Bootstrap)((Bootstrap)b.group(group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

                        @Override
                        protected void initChannel(SocketChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            if (sslCtx != null) {
                                p.addLast(sslCtx.newHandler(ch.alloc(), host, port));
                            }
                            p.addLast(new HttpClientCodec(), new HttpObjectAggregator(0xA00000), websocketClientHandler, forwardClientSocketClientHandler);
                        }
                    });
                    closeFuture = b.connect(this.tunnelServerURI.getHost(), port).sync().channel().closeFuture();
                    logger.info("forward client connect to server success, uri: " + this.tunnelServerURI);
                    if (closeFuture == null) break block5;
                    closeFuture.addListener(new ChannelFutureListener(group){
                        final /* synthetic */ EventLoopGroup val$group;
                        {
                            this.val$group = eventLoopGroup;
                        }

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            this.val$group.shutdownGracefully();
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (closeFuture != null) {
                        closeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        group.shutdownGracefully();
                    }
                    throw throwable;
                }
                break block6;
            }
            group.shutdownGracefully();
        }
    }
}

